import {FunctionComponent} from 'react';
import {useSelector} from 'react-redux';

import {
    COMMON_AGREEMENT_LINK,
    TLD_PLACEHOLDER,
} from 'components/Footer/constants/footerLinks';
import {URLs} from 'constants/urls';

import {IWithClassName} from 'types/withClassName';

import {hotelsListSelector} from 'selectors/hotelsExtranet/hotelsListSelector';

import {useTld} from 'utilities/hooks/useTld';

import * as i18nBlock from 'i18n/hotelsExtranet';

import Flex from 'components/Flex/Flex';
import Link from 'components/Link/Link';
import ButtonLink from 'components/ButtonLink/ButtonLink';

import cx from './Footer.scss';

const FOR_PARTNERS_URL = 'https://yandex.ru/support/travel-partners/';
const REFERENCE_URL = 'https://yandex.ru/support/travel/';

const Footer: FunctionComponent<IWithClassName> = ({className}) => {
    const tld = useTld();
    const {currentHotel} = useSelector(hotelsListSelector);

    if (!currentHotel) {
        return null;
    }

    return (
        <Flex className={cx('root', className)} justifyContent="space-between">
            <Flex inline between={5} alignItems="center">
                <Link
                    className={cx('link')}
                    theme="black"
                    target="_blank"
                    url={FOR_PARTNERS_URL}
                >
                    {i18nBlock.forPartners()}
                </Link>
                <Link
                    className={cx('link')}
                    theme="black"
                    target="_blank"
                    url={COMMON_AGREEMENT_LINK.link.replace(
                        TLD_PLACEHOLDER,
                        tld,
                    )}
                >
                    {COMMON_AGREEMENT_LINK.name}
                </Link>
                <Link
                    className={cx('link')}
                    theme="black"
                    target="_blank"
                    url={REFERENCE_URL}
                >
                    {i18nBlock.reference()}
                </Link>
            </Flex>
            <ButtonLink to={URLs.hotelsExtranetAddHotelPage} size="m">
                {i18nBlock.addNewObject()}
            </ButtonLink>
        </Flex>
    );
};

export default Footer;
