import {useCallback, useMemo} from 'react';

import {IPageable} from 'server/api/HotelsExtranetApi/types/IPageable';

import {getPageCount} from 'projects/hotelsExtranet/utilities/getPageCount';

interface IUsePaginatorResult {
    pageNumber: number;
    pageSize?: number;
    pageCount: number;
    onPageChange(page: number): void;
}

export function usePaginator(
    setPage: (page: number) => void,
    totalRecords?: number,
    page?: IPageable,
): IUsePaginatorResult {
    const pageNumber = (page?.num || 0) + 1;

    const pageCount = useMemo(
        () => getPageCount(totalRecords, page?.limit),
        [totalRecords, page],
    );

    const onPageChange = useCallback(
        newPage => {
            if (pageNumber !== newPage) {
                setPage(newPage - 1);
            }
        },
        [pageNumber, setPage],
    );

    return {
        pageNumber,
        pageCount,
        pageSize: page?.limit,
        onPageChange,
    };
}
