import {FC} from 'react';

import {TSortDirection} from 'types/TSortDirection';

import SortingDefaultIcon from 'icons/20/SortingDefault';
import SortingUpIcon from 'icons/20/SortingUp';
import SortingDownIcon from 'icons/20/SortingDown';

import cx from './SortIcon.scss';

interface ISortIconProps {
    columnName: string;
    sortField?: string;
    sortDirection?: TSortDirection;
}

const SortIcon: FC<ISortIconProps> = ({
    columnName,
    sortField,
    sortDirection,
}) => {
    if (!columnName) {
        return null;
    }

    if (columnName === sortField) {
        if (sortDirection === 'SD_ASC')
            return (
                <SortingUpIcon className={cx('sortIcon', 'sortIcon_active')} />
            );

        return (
            <SortingDownIcon className={cx('sortIcon', 'sortIcon_active')} />
        );
    }

    return (
        <SortingDefaultIcon className={cx('sortIcon', 'sortIcon_inactive')} />
    );
};

export default SortIcon;
