import {EFormKey} from 'constants/form/EFormKey';
import {getEmailValidationRegExp} from 'constants/form/validationRules';

import {TField} from 'types/common/validation/form';
import {EValidationType} from 'types/common/validation/validation';
import {EHotelsExtranetAddHotelRequestFieldName} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetAddHotelRequest';

import * as i18nBlock from 'i18n/hotelsExtranet';

const idValidation: TField = {
    name: EHotelsExtranetAddHotelRequestFieldName.HOTEL_CODE,
    validation: {
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: i18nBlock.idNeeded(),
            },
        ],
    },
};

const emailValidation: TField = {
    name: EHotelsExtranetAddHotelRequestFieldName.EMAIL,
    validation: {
        blur: [
            {
                type: EValidationType.regex,
                params: getEmailValidationRegExp({
                    allowRussianCharacters: true,
                }),
                errorMessage: i18nBlock.incorrectEmail(),
            },
        ],
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: i18nBlock.emailNeeded(),
            },
        ],
    },
};

export const validationInfo = {
    id: EFormKey.HOTELS_EXTRANET_ADD_HOTEL,
    fieldGroups: [
        {
            id: EFormKey.HOTELS_EXTRANET_ADD_HOTEL,
            fields: [idValidation, emailValidation],
        },
    ],
};
