import {ComponentType, FunctionComponent, useCallback} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';
import {EAuthRequestStatus} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetAddHotelResponse';

import {resetAddedHotel} from 'reducers/hotelsExtranet/addHotel/actions';

import {addHotelSelector} from 'selectors/hotelsExtranet/addHotelSelector';

import * as i18nBlock from 'i18n/hotelsExtranet';

import Button from 'components/Button/Button';
import AddHotelResultPage from 'projects/hotelsExtranet/components/AddHotelResultPage/AddHotelResultPage';
import CommonErrorL from 'icons/illustrations/CommonError/CommonErrorL';
import SuccessL from 'icons/illustrations/Success/SuccessL';

function getImage(status?: EAuthRequestStatus): ComponentType<IWithClassName> {
    if (status === EAuthRequestStatus.OK) return SuccessL;

    return CommonErrorL;
}

function getTitle(status?: EAuthRequestStatus): string {
    if (status === EAuthRequestStatus.OK) {
        return i18nBlock.emailSentTitle();
    }

    if (status === EAuthRequestStatus.HOTEL_ID_NOT_FOUND) {
        return i18nBlock.hotelIdNotFoundErrorTitle();
    }

    if (status === EAuthRequestStatus.INVALID_EMAIL) {
        return i18nBlock.invalidEmailErrorTitle();
    }

    if (status === EAuthRequestStatus.ALREADY_REQUESTED) {
        return i18nBlock.alreadyRequestedErrorTitle();
    }

    return i18nBlock.unknownErrorTitle();
}

function getText(status?: EAuthRequestStatus): string | undefined {
    if (status === EAuthRequestStatus.OK) {
        return i18nBlock.emailSentDescription();
    }

    if (status === EAuthRequestStatus.ALREADY_REQUESTED) {
        return i18nBlock.alreadyRequestedErrorText();
    }

    if (status === EAuthRequestStatus.INVALID_EMAIL) {
        return i18nBlock.invalidEmailErrorText();
    }

    return undefined;
}

const RequestResultPage: FunctionComponent = () => {
    const dispatch = useDispatch();
    const {response} = useSelector(addHotelSelector);
    const {status} = response || {};

    const handleAddOneMore = useCallback(
        () => dispatch(resetAddedHotel()),
        [dispatch],
    );

    return (
        <AddHotelResultPage
            ImageComponent={getImage(status)}
            title={getTitle(status)}
            text={getText(status)}
            button={
                <Button
                    type="button"
                    size="m-inset"
                    theme="secondary"
                    onClick={handleAddOneMore}
                >
                    {status === EAuthRequestStatus.OK
                        ? i18nBlock.addOneMoreHotel()
                        : i18nBlock.goToForm()}
                </Button>
            }
        />
    );
};

export default RequestResultPage;
