import {FunctionComponent} from 'react';
import {useSelector} from 'react-redux';

import EAsyncStatus from 'types/common/EAsyncStatus';
import {EApproveRequestStatus} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetApproveHotelResponse';

import {approveHotelSelector} from 'selectors/hotelsExtranet/approveHotelSelector';
import {hotelsListSelector} from 'selectors/hotelsExtranet/hotelsListSelector';

import {useQueryByLocation} from 'utilities/hooks/useQueryByLocation';
import {getHotelId} from 'projects/hotelsExtranet/utilities/getHotelId';

import * as i18nBlock from 'i18n/hotelsExtranet';

import HotelsExtranetLayout from 'projects/hotelsExtranet/components/HotelsExtranetLayout/HotelsExtranetLayout';
import HotelInfo from './components/HotelInfo/HotelInfo';
import Spinner from 'components/Spinner/Spinner';
import ApproveHotelError from './components/ApproveHotelError/ApproveHotelError';
import UpcomingArrivals from './components/UpcomingArrivals/UpcomingArrivals';
import Heading from 'components/Heading/Heading';
import Skeleton from 'components/Skeletons/Skeleton/Skeleton';
import Flex from 'components/Flex/Flex';

import cx from './IndexPage.scss';

const IndexPage: FunctionComponent = () => {
    const {approveToken} = useQueryByLocation();
    const approveRequest = useSelector(approveHotelSelector);
    const {currentHotel} = useSelector(hotelsListSelector);

    const {status: approveRequestStatus, response: approveResponse} =
        approveRequest;

    if (approveToken) {
        if (
            !approveRequestStatus ||
            approveRequestStatus === EAsyncStatus.LOADING
        ) {
            return (
                <HotelsExtranetLayout contentClassName={cx('approveLayout')}>
                    <Spinner />
                </HotelsExtranetLayout>
            );
        }
    }

    if (
        approveResponse &&
        approveResponse.status !== EApproveRequestStatus.OK
    ) {
        return <ApproveHotelError status={approveResponse.status} />;
    }

    return (
        <HotelsExtranetLayout>
            {currentHotel ? (
                <>
                    <Heading className={cx('title')} level="1">
                        {currentHotel.name || getHotelId(currentHotel)}
                    </Heading>
                    <Heading className={cx('title')} level="2">
                        {i18nBlock.upcomingArrivals()}
                    </Heading>
                    <Flex
                        flexDirection="row"
                        justifyContent="space-between"
                        between={4}
                        inline
                        flexWrap="nowrap"
                        className={cx('data')}
                    >
                        <UpcomingArrivals />
                        <HotelInfo />
                    </Flex>
                </>
            ) : (
                <Skeleton className={cx('title', 'titleSkeleton')} />
            )}
        </HotelsExtranetLayout>
    );
};

export default IndexPage;
