import {FunctionComponent} from 'react';

import {URLs} from 'constants/urls';

import {EApproveRequestStatus} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetApproveHotelResponse';

import * as i18nBlock from 'i18n/hotelsExtranet';

import CommonErrorL from 'icons/illustrations/CommonError/CommonErrorL';
import AddHotelResultPage from 'projects/hotelsExtranet/components/AddHotelResultPage/AddHotelResultPage';
import ButtonLink from 'components/ButtonLink/ButtonLink';

interface IApproveHotelErrorProps {
    status: EApproveRequestStatus;
}

function getApproveErrorTitle(status: EApproveRequestStatus): string {
    switch (status) {
        case EApproveRequestStatus.ALREADY_APPROVED:
            return i18nBlock.alreadyApprovedErrorTitle();
        case EApproveRequestStatus.EXPIRED_TOKEN:
            return i18nBlock.expiredTokenErrorTitle();
        case EApproveRequestStatus.INVALID_TOKEN:
            return i18nBlock.invalidTokenErrorTitle();
    }

    return i18nBlock.unknownErrorTitle();
}

function getApproveErrorText(
    status: EApproveRequestStatus,
): string | undefined {
    switch (status) {
        case EApproveRequestStatus.EXPIRED_TOKEN:
            return i18nBlock.expiredTokenErrorText();
        case EApproveRequestStatus.INVALID_TOKEN:
            return i18nBlock.invalidTokenErrorText();
    }

    return undefined;
}

const ApproveHotelError: FunctionComponent<IApproveHotelErrorProps> = ({
    status,
}) => {
    return (
        <AddHotelResultPage
            ImageComponent={CommonErrorL}
            title={getApproveErrorTitle(status)}
            text={getApproveErrorText(status)}
            button={
                <ButtonLink to={URLs.hotelsExtranetAddHotelPage}>
                    {i18nBlock.goToForm()}
                </ButtonLink>
            }
        />
    );
};

export default ApproveHotelError;
