import {FunctionComponent, useMemo} from 'react';
import {useSelector} from 'react-redux';

import {EHotelsExtranetGoal} from 'utilities/metrika/types/goals/hotelsExtranet';

import {hotelsListSelector} from 'selectors/hotelsExtranet/hotelsListSelector';

import {getHotelUrl} from './utilities/getHotelUrl';
import {useReachGoal} from 'utilities/metrika/useReachGoal';

import * as i18nBlock from 'i18n/hotelsExtranet';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import NoHotelPhotoXL from 'icons/illustrations/NoHotelPhoto/NoHotelPhotoXL';
import ButtonLink from 'components/ButtonLink/ButtonLink';

import cx from './HotelInfo.scss';

const HotelInfo: FunctionComponent = () => {
    const {currentHotel} = useSelector(hotelsListSelector);
    const hotelPath = useMemo(() => getHotelUrl(currentHotel), [currentHotel]);
    const handleHotelUrlClick = useReachGoal(
        EHotelsExtranetGoal.HOTEL_URL_CLICK,
        [
            {
                hotelsExtranet: {
                    page: 'main',
                },
            },
        ],
    );

    return (
        <Flex
            className={cx('ballance')}
            flexDirection="row"
            alignItems="flex-start"
            between={2}
        >
            <Flex flexDirection="column">
                <Text size="m">
                    {i18nBlock.youCanSeeWhatYourHotelLooksLike()}
                </Text>
                {hotelPath && (
                    <ButtonLink
                        className={cx('viewButton')}
                        theme="plain"
                        size="m"
                        to={hotelPath}
                        target="_blank"
                        onClick={handleHotelUrlClick}
                    >
                        {i18nBlock.goTo()}
                    </ButtonLink>
                )}
            </Flex>
            <NoHotelPhotoXL className={cx('image')} />
        </Flex>
    );
};

export default HotelInfo;
