import {IExtranetHotel} from 'server/api/HotelsExtranetApi/types/IHotelsListResponse';

import {
    getHotelUrlByHotelSlug,
    getHotelUrlByPermalink,
} from 'projects/hotels/utilities/urls/getHotelUrl';

export function getHotelUrl(hotel?: IExtranetHotel): string | undefined {
    if (!hotel) {
        return undefined;
    }

    const {slug, permalink} = hotel;

    if (slug) {
        return getHotelUrlByHotelSlug(slug);
    }

    if (permalink) {
        return getHotelUrlByPermalink(permalink);
    }

    return undefined;
}
