import {FC} from 'react';

import {IWithClassName} from 'types/withClassName';

import {useBoolean} from 'utilities/hooks/useBoolean';

import * as i18nBlock from 'i18n/hotelsExtranet';

import Heading from 'components/Heading/Heading';
import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import Button from 'components/Button/Button';
import Modal from 'components/Modal/Modal';

import cx from './Offer.scss';

const Offer: FC<IWithClassName> = () => {
    const {
        value: isOfferModalVisible,
        setTrue: setOfferModalVisible,
        setFalse: setOfferModalHidden,
    } = useBoolean(false);

    return (
        <Flex
            className={cx('offer', 'panel')}
            flexDirection="column"
            alignItems="flex-start"
            between={3}
        >
            <Text className={cx('requisites')}>
                Договор №1111967/20 от 21.09.20 Р/сч 40702810352090006979 в
                ЮГО-ЗАПАДНЫЙ БАНК ПАО СБЕРБАНК (046015602), ООО МетаМосква
            </Text>
            <Button
                className={cx('button')}
                size="m"
                theme="plain"
                onClick={setOfferModalVisible}
            >
                {i18nBlock.offer()}
            </Button>
            <Modal
                isVisible={isOfferModalVisible}
                onClose={setOfferModalHidden}
                dialogClassName={cx('offerModal')}
            >
                <Flex
                    className={cx('offerModalContent')}
                    flexDirection="column"
                    between={4}
                >
                    <Heading level="2">{i18nBlock.offer()}</Heading>
                    <Text>{i18nBlock.offerDescription1()}</Text>
                    <Text>{i18nBlock.offerDescription2()}</Text>
                </Flex>
            </Modal>
        </Flex>
    );
};

export default Offer;
