import {FunctionComponent, useEffect} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import EAsyncStatus from 'types/common/EAsyncStatus';

import {fetchOrders} from 'reducers/hotelsExtranet/orders/thunk';

import {ordersSelector} from 'selectors/hotelsExtranet/ordersSelector';
import {hotelsListSelector} from 'selectors/hotelsExtranet/hotelsListSelector';

import * as i18nBlock from 'i18n/hotelsExtranet';

import HotelsExtranetLayout from 'projects/hotelsExtranet/components/HotelsExtranetLayout/HotelsExtranetLayout';
import Heading from 'components/Heading/Heading';
import Spinner from 'components/Spinner/Spinner';
import OrdersTable from './components/OrdersTable/OrdersTable';
import Filters from './components/Filters/Filters';
import Paginator from './components/OrdersPaginator/OrdersPaginator';
import Flex from 'components/Flex/Flex';
// import DownloadIcon from 'icons/16/Download';
// import ButtonLink from 'components/ButtonLink/ButtonLink';
import Text from 'components/Text/Text';
import {DEFAULT_PAGE_SIZE} from 'projects/hotelsExtranet/components/Paginator/Paginator';

import cx from './OrdersPage.scss';

const OrdersPage: FunctionComponent = () => {
    const dispatch = useDispatch();
    const {response, request, status} = useSelector(ordersSelector);
    const {currentHotel} = useSelector(hotelsListSelector);

    const {result, partnerSum, fiscalSum} = response || {};
    const {sortFields} = request || {};

    useEffect(() => {
        if (!status && currentHotel) {
            dispatch(
                fetchOrders({
                    originalId: currentHotel.hotelCode,
                    partnerId: currentHotel.partnerId,
                    page: {
                        num: 0,
                        limit: DEFAULT_PAGE_SIZE,
                    },
                }),
            );
        }
    }, [dispatch, status, currentHotel]);

    return (
        <HotelsExtranetLayout>
            <Heading className={cx('title')} level="1">
                {i18nBlock.orders()}
            </Heading>
            {status === EAsyncStatus.LOADING && !result && (
                <Spinner className={cx('spinner')} />
            )}
            {status === EAsyncStatus.ERROR && (
                <Text className={cx('error')} color="alert" tag="div">
                    {i18nBlock.failedToLoadOrders()}
                </Text>
            )}
            {result && (
                <>
                    <Flex
                        className={cx('filters')}
                        justifyContent="space-between"
                        alignItems="flex-end"
                    >
                        <Filters />
                        {/* <ButtonLink
                            className={cx('downloadButton')}
                            theme="outlined"
                            url="#"
                            iconLeft={
                                <DownloadIcon className={cx('downloadIcon')} />
                            }
                            size="m"
                        >
                            {i18nBlock.download()}
                        </ButtonLink> */}
                    </Flex>
                    {result?.length === 0 ? (
                        <Text className={cx('noData')} tag="div">
                            {i18nBlock.noData()}
                        </Text>
                    ) : (
                        <>
                            <div className={cx('tableWrap')}>
                                <OrdersTable
                                    className={cx('table')}
                                    items={result}
                                    partnerSum={partnerSum}
                                    fiscalSum={fiscalSum}
                                    sortBy={
                                        sortFields ? sortFields[0] : undefined
                                    }
                                    withSort
                                    withSpinner={
                                        status === EAsyncStatus.LOADING
                                    }
                                />
                            </div>
                            <Paginator className={cx('paginator')} />
                        </>
                    )}
                </>
            )}
        </HotelsExtranetLayout>
    );
};

export default OrdersPage;
