import {FunctionComponent, useCallback, useMemo} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';
import {EHotelsExtranetGoal} from 'utilities/metrika/types/goals/hotelsExtranet';
import {TMetrikaParams} from 'utilities/metrika/types/params/all';

import {setPage, setPageSize} from 'reducers/hotelsExtranet/orders/thunk';

import {ordersSelector} from 'selectors/hotelsExtranet/ordersSelector';

import {useReachGoal} from 'utilities/metrika/useReachGoal';

import * as i18nBlock from 'i18n/hotelsExtranet';

import {usePaginator} from 'projects/hotelsExtranet/components/Paginator/hooks/usePaginator';
import Paginator from 'projects/hotelsExtranet/components/Paginator/Paginator';

const OrdersPaginator: FunctionComponent<IWithClassName> = ({className}) => {
    const dispatch = useDispatch();
    const {response, request} = useSelector(ordersSelector);
    const {page} = request || {};
    const {totalRecords} = response || {};
    const metrikaParams: TMetrikaParams = useMemo(
        () => ({
            hotelsExtranet: {
                page: 'orders',
            },
        }),
        [],
    );

    const handlePageInput = useReachGoal(EHotelsExtranetGoal.PAGE_INPUT, [
        metrikaParams,
    ]);
    const handlePageArrowClick = useReachGoal(
        EHotelsExtranetGoal.PAGE_ARROW_CLICK,
        [metrikaParams],
    );
    const handlePageSizeClick = useReachGoal(
        EHotelsExtranetGoal.SELECT_PAGE_SIZE,
        [metrikaParams],
    );
    const handlePageSizeChange = useCallback(
        newPageSize => {
            dispatch(setPageSize(newPageSize));
        },
        [dispatch],
    );

    const handleSetPage = useCallback(
        newPage => {
            dispatch(setPage(newPage));
        },
        [dispatch],
    );

    return (
        <Paginator
            className={className}
            onPageSizeChange={handlePageSizeChange}
            onPageSizeChangeClick={handlePageSizeClick}
            onPageInput={handlePageInput}
            onPageArrowClick={handlePageArrowClick}
            pageSizeLabel={i18nBlock.ordersPerPage()}
            {...usePaginator(handleSetPage, totalRecords, page)}
        />
    );
};

export default OrdersPaginator;
