import {FunctionComponent, useCallback, useMemo} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';
import {EHotelsExtranetGoal} from 'utilities/metrika/types/goals/hotelsExtranet';
import {TMetrikaParams} from 'utilities/metrika/types/params/all';

import {setPage, setPageSize} from 'reducers/hotelsExtranet/payments/thunk';

import {paymentsSelector} from 'selectors/hotelsExtranet/paymentsSelector';

import {reachGoal} from 'utilities/metrika';
import {useReachGoal} from 'utilities/metrika/useReachGoal';

import * as i18nBlock from 'i18n/hotelsExtranet';

import {usePaginator} from 'projects/hotelsExtranet/components/Paginator/hooks/usePaginator';
import Paginator from 'projects/hotelsExtranet/components/Paginator/Paginator';

const PaymentsPaginator: FunctionComponent<IWithClassName> = ({className}) => {
    const dispatch = useDispatch();
    const {response, request} = useSelector(paymentsSelector);
    const {totalRecords} = response || {};
    const {page} = request || {};
    const metrikaParams: TMetrikaParams = useMemo(
        () => ({
            hotelsExtranet: {
                page: 'payments',
            },
        }),
        [],
    );

    const handlePageInput = useReachGoal(EHotelsExtranetGoal.PAGE_INPUT, [
        metrikaParams,
    ]);
    const handlePageArrowClick = useReachGoal(
        EHotelsExtranetGoal.PAGE_ARROW_CLICK,
        [metrikaParams],
    );

    const handlePageSizeClick = useReachGoal(
        EHotelsExtranetGoal.SELECT_PAGE_SIZE,
        [metrikaParams],
    );
    const handlePageSizeChange = useCallback(
        newPageSize => {
            dispatch(setPageSize(newPageSize));
            reachGoal(EHotelsExtranetGoal.SELECT_PAGE_SIZE, [metrikaParams]);
        },
        [dispatch, metrikaParams],
    );

    const handleSetPage = useCallback(
        newPage => {
            dispatch(setPage(newPage));
        },
        [dispatch],
    );

    return (
        <Paginator
            className={className}
            onPageSizeChange={handlePageSizeChange}
            onPageSizeChangeClick={handlePageSizeClick}
            onPageInput={handlePageInput}
            onPageArrowClick={handlePageArrowClick}
            pageSizeLabel={i18nBlock.paymentsPerPage()}
            {...usePaginator(handleSetPage, totalRecords, page)}
        />
    );
};

export default PaymentsPaginator;
