import {FunctionComponent, useCallback} from 'react';
import moment from 'moment';

import {IExtranetPaymentInfo} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetPaymentsResponse';
import {EHotelsExtranetGoal} from 'utilities/metrika/types/goals/hotelsExtranet';

import {HUMAN_WITH_YEAR} from 'utilities/dateUtils/formats';
import {useBoolean} from 'utilities/hooks/useBoolean';
import {formatPrice} from 'projects/hotelsExtranet/utilities/formatPrice';
import {reachGoal} from 'utilities/metrika';

import Text from 'components/Text/Text';
import AutoHeightAnimateControl from 'components/AutoHeightAnimateControl/AutoHeightAnimateControl';
import Flex from 'components/Flex/Flex';
import RotatingArrowIcon from 'components/RotatingArrowIcon/RotatingArrowIcon';

import PaymentDetails from '../PaymentDetails/PaymentDetails';

import cx from './PaymentsTableRow.scss';

interface IPaymentTableRowProps {
    item: IExtranetPaymentInfo;
    cellClassName?: string;
}

const PaymentsTableRow: FunctionComponent<IPaymentTableRowProps> = ({
    cellClassName,
    item,
}) => {
    const {value: isExpanded, toggle: toggleExpanded} = useBoolean(false);

    const handleExpandClick = useCallback(() => {
        if (!isExpanded) {
            reachGoal(EHotelsExtranetGoal.EXPAND_PAYMENT_DETAILS, {
                hotelsExtranet: {
                    page: 'payments',
                },
            });
        }

        toggleExpanded();
    }, [isExpanded, toggleExpanded]);

    const {bankOrderId, eventTime, sum, paymentBatchId} = item;

    return (
        <>
            <tr
                className={cx('root', isExpanded && 'root_expanded')}
                onClick={handleExpandClick}
            >
                <td className={cx('cell', cellClassName)}>
                    {moment(eventTime).format(HUMAN_WITH_YEAR)}
                </td>
                <td className={cx('cell', cellClassName)}>
                    <Text whiteSpace="nowrap">{formatPrice(sum)}</Text>
                </td>
                <td className={cx('cell', cellClassName)}>
                    <Flex
                        flexDirection="row"
                        alignItems="center"
                        justifyContent="space-between"
                    >
                        {bankOrderId}
                        <div className={cx('arrowWrap')}>
                            <RotatingArrowIcon rotated={isExpanded} />
                        </div>
                    </Flex>
                </td>
            </tr>
            <tr
                className={cx(
                    'expandableRow',
                    isExpanded && 'expandableRow_expanded',
                )}
            >
                <td colSpan={3}>
                    <AutoHeightAnimateControl canShowComponent={isExpanded}>
                        {isExpanded && (
                            <PaymentDetails
                                paymentBatchId={paymentBatchId}
                                total={sum}
                            />
                        )}
                    </AutoHeightAnimateControl>
                </td>
            </tr>
        </>
    );
};

export default PaymentsTableRow;
