import IPrice from 'types/common/price/IPrice';

import {formatPrice as baseFormatPrice} from 'utilities/currency';
import {CHAR_EM_DASH} from 'utilities/strings/charCodes';

// TODO: выпилить это когда с бекенда будет приходить IPrice
export function formatPrice(price: IPrice | string | undefined): string {
    if (typeof price === 'undefined') {
        return CHAR_EM_DASH;
    }

    if (typeof price === 'string') {
        return price;
    }

    return baseFormatPrice({...price, forceCentsVisibility: true});
}
