import {ISortBy} from 'server/api/HotelsExtranetApi/types/ISortBy';

export function getNewSortBy<T>(
    clickedColumnName?: T,
    currentSortBy?: ISortBy<T>,
): ISortBy<T> | undefined {
    if (!clickedColumnName) {
        return undefined;
    }

    if (!currentSortBy || currentSortBy.field !== clickedColumnName) {
        return {
            field: clickedColumnName,
            sortDirection: 'SD_ASC',
        };
    }

    if (currentSortBy.sortDirection === 'SD_ASC') {
        return {
            field: clickedColumnName,
            sortDirection: 'SD_DESC',
        };
    }

    return undefined;
}
