import {
    AWAITS_PAYMENT,
    CANCELLED,
    CANCELLED_WITH_REFUND,
    CONFIRMED,
    FAILED,
    IN_PROGRESS,
    PAYMENT_FAILED,
    REFUNDED,
    REFUND_FAILED,
    RESERVED,
    RESERVED_WITH_RESTRICTIONS,
} from 'projects/hotels/constants/hotelsBookingStatuses';

import * as i18nBlock from 'i18n/hotels-OrderStatus';

export function getOrderStatus(status: string): string {
    switch (status) {
        case IN_PROGRESS:
            return i18nBlock.inProgress();
        case RESERVED:
            return i18nBlock.reserved();
        case RESERVED_WITH_RESTRICTIONS:
            return i18nBlock.reservedWithRestrictions();
        case AWAITS_PAYMENT:
            return i18nBlock.awaitsPayment();
        case PAYMENT_FAILED:
            return i18nBlock.paymentFailed();
        case CONFIRMED:
            return i18nBlock.confirmed();
        case CANCELLED:
            return i18nBlock.cancelled();
        case CANCELLED_WITH_REFUND:
            return i18nBlock.cancelledWithRefund();
        case REFUNDED:
            return i18nBlock.refunded();
        case REFUND_FAILED:
            return i18nBlock.refundFailed();
        case FAILED:
            return i18nBlock.failed();
    }

    return status;
}
