import {ParsedQuery} from 'query-string';

import EHotelPartnerId from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/EHotelPartnerId';
import {IHotelsExtranetAddHotelRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetAddHotelRequest';

import {useQueryByLocation} from 'utilities/hooks/useQueryByLocation';
import {getFirstOrDefault} from 'utilities/url/getFirstOrDefault';

interface IAddFormPrefillResult {
    prefill: Partial<IHotelsExtranetAddHotelRequest>;
    fromAuth: boolean;
    hasValues: boolean;
}

const FROM_AUTH_PARAM_NAME = 'fromAuth';

export function isFromAuth(query: ParsedQuery): boolean {
    return Boolean(query[FROM_AUTH_PARAM_NAME]);
}

export function setFromAuth(params: Record<string, unknown>): void {
    params[FROM_AUTH_PARAM_NAME] = true;
}

export function useAddFormQueryParams(): IAddFormPrefillResult {
    const query = useQueryByLocation();
    const {email, hotelCode, partnerID} = query;

    return {
        prefill: {
            email: getFirstOrDefault(email),
            hotelCode: getFirstOrDefault(hotelCode),
            partnerID: getFirstOrDefault(partnerID) as EHotelPartnerId,
        },
        fromAuth: isFromAuth(query),
        hasValues: Boolean(email) || Boolean(hotelCode) || Boolean(partnerID),
    };
}
