import {useEffect} from 'react';
import {useDispatch, useSelector} from 'react-redux';
import {useHistory} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {EApproveRequestStatus} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetApproveHotelResponse';
import EAsyncStatus from 'types/common/EAsyncStatus';

import {approveHotel} from 'reducers/hotelsExtranet/approveHotel/thunk';

import {approveHotelSelector} from 'selectors/hotelsExtranet/approveHotelSelector';

import {useQueryByLocation} from 'utilities/hooks/useQueryByLocation';
import {isAuthUser} from 'utilities/userInfo/isAuthUser';
import {useUserInfo} from 'utilities/hooks/useUserInfo';

const useApproveHotel = (): void => {
    const {approveToken} = useQueryByLocation();
    const approveRequest = useSelector(approveHotelSelector);
    const dispatch = useDispatch();
    const history = useHistory();
    const userInfo = useUserInfo();

    const {status, response} = approveRequest;

    useEffect(() => {
        if (approveToken && !status) {
            dispatch(
                approveHotel({
                    token: Array.isArray(approveToken)
                        ? approveToken[0]
                        : approveToken,
                }),
            );
        }
    }, [approveToken, status, dispatch]);

    useEffect(() => {
        if (status === EAsyncStatus.SUCCESS) {
            if (response?.status === EApproveRequestStatus.OK) {
                if (isAuthUser(userInfo)) {
                    location.search = '';
                    history.replace(URLs.hotelsExtranetRoot);
                } else {
                    history.replace(URLs.hotelsExtranetAddHotelPage);
                }
            } else if (isAuthUser(userInfo)) {
                history.replace(URLs.hotelsExtranetRoot);
            }
        }
    }, [response, history, status, userInfo]);
};

export default useApproveHotel;
