import {Meta} from '@storybook/react/types-6-0';
import times from 'lodash/times';

import {TStorybookFunctionComponent} from 'storybook/types';
import ICrossLinksGalleryItem from 'projects/index/IndexApp/components/CrossLinksGallery/types/ICrossLinksGalleryItem';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import Text from 'components/Text/Text';

import CrossLinksGallery from './CrossLinksGallery';

export default {
    title: 'Index/CrossLinksGallery',
    component: CrossLinksGallery,
} as Meta;

const item: ICrossLinksGalleryItem = {
    id: 'some-id',
    image: 'https://avatars.mds.yandex.net/get-travel-hotels/2456341/region_image_213_0/region-desktop',
    title: 'Москва',
    price: {
        currency: CurrencyType.RUB,
        value: 500,
    },
};

export const Simple: TStorybookFunctionComponent = () => (
    <CrossLinksGallery
        title={
            <Text size="xxl" weight="bold">
                Продающий заголовок
            </Text>
        }
        items={times(18).map(i => ({...item, id: i.toString()}))}
        nonce="nonce"
        markupText="Текст для разметки"
    />
);

Simple.parameters = {
    info: {
        title: 'Галерея перекрестных направлений',
    },
};

export const Skeleton: TStorybookFunctionComponent = () => (
    <CrossLinksGallery
        title={
            <Text size="xxl" weight="bold">
                Продающий заголовок
            </Text>
        }
        items={[]}
        loading
        nonce="nonce"
        markupText="Текст для разметки"
    />
);

Skeleton.parameters = {
    info: {
        title: 'Скелетон галереи перекрестных направлений',
    },
};
