import {Meta} from '@storybook/react/types-6-0';
import React from 'react';

import {TStorybookFunctionComponent} from 'storybook/types';
import ECrossLinkImageSize from 'projects/index/IndexApp/components/CrossLinksGallery/components/CrossLinkImage/types/ECrossLinkImageSize';

import Flex from 'components/Flex/Flex';

import CrossLinkImage from './CrossLinkImage';

export default {
    title: 'Index/CrossLinkImage',
    component: CrossLinkImage,
} as Meta;

const ImageDemoLayout: React.FC<{
    size: ECrossLinkImageSize;
}> = ({size}) => {
    return (
        <Flex
            inset={2}
            flexDirection="column"
            between={4}
            style={{backgroundColor: 'white'}}
        >
            <Flex inline between={2} alignItems="center">
                <CrossLinkImage
                    size={size}
                    src="https://avatars.mds.yandex.net/get-travel-hotels/2456341/region_image_213_0/region-desktop"
                    loading
                />
                <div>Скелетон</div>
            </Flex>
            <Flex inline between={2} alignItems="center">
                <CrossLinkImage
                    size={size}
                    src="https://avatars.mds.yandex.net/get-travel-hotels/2456341/region_image_213_0/region-desktop"
                />
                <div>Картинка есть и указана верно</div>
            </Flex>
            <Flex inline between={2} alignItems="center">
                <CrossLinkImage size={size} src={undefined} />
                <div>Картинка отсутствует</div>
            </Flex>
            <Flex inline between={2} alignItems="center">
                <CrossLinkImage size={size} src="wrong_url" />
                <div>Не удалось загрузить картинку</div>
            </Flex>
        </Flex>
    );
};

export const SizeS: TStorybookFunctionComponent = () => (
    <ImageDemoLayout size={ECrossLinkImageSize.S} />
);

SizeS.parameters = {
    info: {
        title: 'Размер S',
    },
};

export const SizeM: TStorybookFunctionComponent = () => (
    <ImageDemoLayout size={ECrossLinkImageSize.M} />
);

SizeM.parameters = {
    info: {
        title: 'Размер M',
    },
};
