import React, {useMemo} from 'react';

import ECrossLinkImageSize from 'projects/index/IndexApp/components/CrossLinksGallery/components/CrossLinkImage/types/ECrossLinkImageSize';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import TravelImage from 'components/TravelImage/TravelImage';
import Skeleton from 'components/Skeletons/Skeleton/Skeleton';
import ImageIcon from 'components/ImageIcon/ImageIcon';

import cx from './CrossLinkImage.scss';

interface ICrossLinkImageProps extends IWithClassName, IWithQaAttributes {
    src: string | undefined;
    size: ECrossLinkImageSize;
    loading?: boolean;
    onError?(): void;
}

const CrossLinkImage: React.FC<ICrossLinkImageProps> = props => {
    const {className, src, size, loading = false, onError} = props;

    const deviceType = useDeviceType();

    const imageStub = useMemo(() => {
        return (
            <ImageIcon
                className={cx('stub')}
                src="https://yastatic.net/s3/travel/static/images/unknown-city.png"
            />
        );
    }, []);

    const rootClassName = cx(
        className,
        'root',
        deviceMods('root', deviceType),
        `root_${size}`,
    );

    if (loading) {
        return <Skeleton className={rootClassName} withAnimation />;
    }

    return (
        <TravelImage
            className={rootClassName}
            src={src}
            onError={onError}
            imageStub={imageStub}
            {...prepareQaAttributes(props)}
        />
    );
};

export default CrossLinkImage;
