import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import ECrossLinkItemType from 'projects/index/IndexApp/components/CrossLinksGallery/components/CrossLinkItem/types/ECrossLinkItemType';
import ICrossLinksGalleryItem from 'projects/index/IndexApp/components/CrossLinksGallery/types/ICrossLinksGalleryItem';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import CrossLinkItem from './CrossLinkItem';

export default {
    title: 'Index/CrossLinkItem',
    component: CrossLinkItem,
} as Meta;

const item: ICrossLinksGalleryItem = {
    id: 'some-id',
    image: 'https://avatars.mds.yandex.net/get-travel-hotels/2456341/region_image_213_0/region-desktop',
    title: 'Москва',
    price: {
        currency: CurrencyType.RUB,
        value: 500,
    },
};

export const TypeCard: TStorybookFunctionComponent = () => (
    <CrossLinkItem type={ECrossLinkItemType.CARD} item={item} />
);

TypeCard.parameters = {
    info: {
        title: 'Элемент галереи типа карточка',
    },
};

export const TypeRow: TStorybookFunctionComponent = () => (
    <CrossLinkItem type={ECrossLinkItemType.ROW} item={item} />
);

TypeRow.parameters = {
    info: {
        title: 'Элемент галереи типа строка',
    },
};
