import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';
import ECrossLinkItemType from 'projects/index/IndexApp/components/CrossLinksGallery/components/CrossLinkItem/types/ECrossLinkItemType';

import getImageSizeByType from 'projects/index/IndexApp/components/CrossLinksGallery/components/CrossLinkItem/utilities/getImageSizeByType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import CrossLinkImage from 'projects/index/IndexApp/components/CrossLinksGallery/components/CrossLinkImage/CrossLinkImage';
import Flex from 'components/Flex/Flex';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';

import cx from './CrossLinkItemSkeleton.scss';

interface ICrossLinkItemSkeletonProps
    extends IWithClassName,
        IWithQaAttributes {
    type: ECrossLinkItemType;
}

const CrossLinkItemSkeleton: React.FC<ICrossLinkItemSkeletonProps> = props => {
    const {className, type} = props;

    const imageSize = useMemo(() => getImageSizeByType(type), [type]);

    return (
        <div
            className={cx(className, 'root', `root_${type}`)}
            {...prepareQaAttributes(props)}
        >
            <CrossLinkImage
                className={cx('image')}
                src={undefined}
                size={imageSize}
                loading
            />
            <Flex flexDirection="column" between={1}>
                <TextSkeleton className={cx('title')} size="l" />
                <TextSkeleton className={cx('price')} size="m" />
            </Flex>
        </div>
    );
};

export default CrossLinkItemSkeleton;
