import React from 'react';

import ICrossLinksGalleryItem from 'projects/index/IndexApp/components/CrossLinksGallery/types/ICrossLinksGalleryItem';

import SchemaMarkup, {
    getAggregateOffer,
} from 'components/SchemaMarkup/SchemaMarkup';

interface ICrossLinksSchemaMarkupProps {
    nonce: string;
    markupText: string;
    items: ICrossLinksGalleryItem[];
}

const CrossLinksSchemaMarkup: React.FC<ICrossLinksSchemaMarkupProps> =
    props => {
        const {nonce, markupText, items} = props;

        return (
            <>
                {items.map((item, i) => {
                    if (!item.price || !item.url) {
                        return null;
                    }

                    return (
                        <SchemaMarkup
                            data={getAggregateOffer({
                                name: markupText,
                                price: item.price,
                                url: item.url,
                            })}
                            key={i}
                            nonce={nonce}
                        />
                    );
                })}
            </>
        );
    };

export default React.memo(CrossLinksSchemaMarkup);
