import ECrossLinkItemType from 'projects/index/IndexApp/components/CrossLinksGallery/components/CrossLinkItem/types/ECrossLinkItemType';
import {IWithDeviceType} from 'types/withDeviceType';

interface IGetItemTypeParams extends IWithDeviceType {
    index: number;
    cardCount: number;
}

export default function getItemType({
    deviceType,
    index,
    cardCount,
}: IGetItemTypeParams): ECrossLinkItemType {
    if (deviceType.isMobile) {
        return ECrossLinkItemType.CARD;
    }

    return index < cardCount ? ECrossLinkItemType.CARD : ECrossLinkItemType.ROW;
}
