import React, {MutableRefObject, useEffect} from 'react';

import {EAviaGoal} from 'utilities/metrika/types/goals/avia';
import {ESearchFormFieldName} from 'components/SearchForm/types';
import {IAviaSuggest} from 'types/avia/suggests/IAviaSuggest';

import {reachGoal} from 'utilities/metrika';
import {getSuggestForAnywhere} from 'projects/avia/lib/getSuggestForAnywhere';

import * as i18nSearchToAnywhere from 'i18n/avia-SearchToAnywhere';

import SearchPreset from 'components/SearchPreset/SearchPreset';
import GlobeIcon from 'icons/24/Globe';
import {IFormFieldsRef} from 'components/SearchForm/SearchForm';
import {
    ESuggestSource,
    ISuggestValue,
} from 'components/SearchSuggest/SearchSuggest';

interface IAnywherePresetProps {
    searchFormFieldsRef: MutableRefObject<IFormFieldsRef | undefined>;
    setToPoint(fieldValue: ISuggestValue<IAviaSuggest>): void;
    index: number;
}

const AnywherePreset: React.FC<IAnywherePresetProps> = ({
    searchFormFieldsRef,
    setToPoint,
    index,
}) => {
    useEffect(() => {
        reachGoal(EAviaGoal.AVIA_TO_ANYWHERE_PRESET_SHOW);
    }, []);

    const handleClick = (): void => {
        const searchForm = searchFormFieldsRef.current;

        if (searchForm) {
            const suggestForAnywhere = getSuggestForAnywhere();

            setToPoint({
                selectedValue: suggestForAnywhere,
                inputValue: suggestForAnywhere.title,
                source: ESuggestSource.PRESETS,
            });

            searchForm.focusFieldByName(ESearchFormFieldName.START_DATE);

            reachGoal(EAviaGoal.AVIA_TO_ANYWHERE_PRESET_CLICK);
        }
    };

    return (
        <SearchPreset
            onClick={handleClick}
            title={i18nSearchToAnywhere.suggestTitle()}
            secondRow={i18nSearchToAnywhere.citiesAndRestrictions()}
            Icon={GlobeIcon}
            theme="blue"
            index={index}
        />
    );
};

export default React.memo(AnywherePreset);
