import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';
import moment from 'moment';

import {TStorybookFunctionComponent} from 'storybook/types';
import IPersonalizedHotelItem from 'server/api/PersonalizationApi/types/IPersonalizedHotelItem';
import EPersonalizedItemType from 'server/api/PersonalizationApi/types/EPersonalizedItemType';
import ILinguistics from 'types/common/ILinguistics';

import CrossSalePreset from './CrossSalePreset';

export default {
    title: 'Index/CrossSalePreset',
    component: CrossSalePreset,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <CrossSalePreset
        item={
            {
                type: EPersonalizedItemType.CROSS_SALE,
                offerSearchParams: {
                    adults: 2,
                    childrenAges: [],
                    region: {},
                    checkinDate: moment().add(1, 'day').toISOString(),
                    checkoutDate: moment().add(2, 'day').toISOString(),
                },
                region: {
                    geoId: 111,
                    linguistics: {
                        nominativeCase: 'Санкт-Петербург',
                    } as ILinguistics,
                },
            } as IPersonalizedHotelItem
        }
        width="auto"
        index={0}
    />
);

Simple.parameters = {
    info: {
        title: 'Пресет кроссейла отелей в авиа',
    },
};
