import React, {useCallback} from 'react';
import {useHistory} from 'react-router-dom';

import {EYtpReferer} from 'types/common/IAttribution';
import {EAviaGoal} from 'utilities/metrika/types/goals/avia';
import IPersonalizedHotelItem from 'server/api/PersonalizationApi/types/IPersonalizedHotelItem';

import {reachGoal} from 'utilities/metrika';
import humanizePeriod from 'utilities/dateUtils/humanizePeriod';
import {getCrossSaleHotelsSearchUrl} from 'projects/avia/utilities/getCrossSaleHotelsSearchUrl';

import HotelIcon from 'icons/24/Hotel';
import SearchPreset from 'components/SearchPreset/SearchPreset';

interface ICrossSalePresetProps {
    item: IPersonalizedHotelItem;
    width: 'auto' | 'max';
    index: number;
}

const CrossSalePreset: React.FC<ICrossSalePresetProps> = ({
    item,
    width,
    index,
}: ICrossSalePresetProps) => {
    const history = useHistory();

    const {offerSearchParams, region} = item;

    const handleClick = useCallback(() => {
        history?.push(
            getCrossSaleHotelsSearchUrl({
                ytpReferer: EYtpReferer.AVIA_MORDA_CROSSALE,
                geoId: region.geoId,
                offerSearchParams,
            }),
        );

        reachGoal(EAviaGoal.MORDA_CROSS_SALE_CLICK);
    }, [history, offerSearchParams, region]);

    const secondRow = humanizePeriod(
        offerSearchParams.checkinDate,
        offerSearchParams.checkoutDate,
        {
            short: true,
            checkSameDate: false,
            checkAnotherEndYear: false,
        },
    );

    return (
        <SearchPreset
            onClick={handleClick}
            title={region.linguistics.nominativeCase}
            secondRow={secondRow}
            Icon={HotelIcon}
            theme="blue"
            width={width}
            index={index}
        />
    );
};

export default React.memo(CrossSalePreset);
