import {useCallback, useState} from 'react';

import {IAviaMinPriceSearchResult} from 'server/api/AviaPriceIndexApi/types/IAviaMinPriceBatchSearchApiResponse';
import {IAviaMinPriceBatchSearchServiceParams} from 'server/services/AviaPriceIndexService/types/IAviaMinPriceBatchSearchService';

import {useAsyncState} from 'utilities/hooks/useAsyncState';

import {EAviaPriceIndexSearchStatus} from 'server/api/AviaPriceIndexApi/enums/EAviaPriceIndexSearchStatus';

import {aviaPriceIndexBrowserProvider} from 'serviceProvider/avia/aviaPriceIndexBrowserProvider';

interface IMinPriceForSearchPresets {
    isLoading: boolean;
    isSuccess: boolean;
    isError: boolean;
    fetch(params: IAviaMinPriceBatchSearchServiceParams): Promise<void>;
    prices: IAviaMinPriceSearchResult[];
}

export default function useMinPriceForSearchPresets(): IMinPriceForSearchPresets {
    const {reset, loading, success, error, isError, isSuccess, isLoading} =
        useAsyncState();
    const [prices, setPrices] = useState<IAviaMinPriceSearchResult[]>([]);

    const fetch = useCallback(
        async (
            params: IAviaMinPriceBatchSearchServiceParams,
        ): Promise<void> => {
            reset();

            try {
                loading();

                const res =
                    await aviaPriceIndexBrowserProvider.minPriceBatchSearch(
                        params,
                    );

                if (res.status !== EAviaPriceIndexSearchStatus.OK) {
                    setPrices([]);

                    return;
                }

                setPrices(res.data);

                success();
            } catch (e) {
                setPrices([]);

                error();
            }
        },
        [error, loading, reset, success],
    );

    return {
        isLoading,
        isError,
        isSuccess,
        fetch,
        prices,
    };
}
