import {IAviaMinPriceBatchSearchServiceParams} from 'server/services/AviaPriceIndexService/types/IAviaMinPriceBatchSearchService';
import {isNotNull} from 'types/utilities';

import {ISearchHistoryInfo} from 'reducers/avia/personalization/reducer';

import getPointIdByPointKey from './getPointIdByPointKey';

export default function convertSearchHistoryToAviaMinPriceBatchSearchParams(
    searchHistory: ISearchHistoryInfo,
): IAviaMinPriceBatchSearchServiceParams {
    const minRequests = searchHistory.items
        .map(item => {
            const fromId = getPointIdByPointKey(item.from.pointKey);
            const toId = getPointIdByPointKey(item.to.pointKey);

            if (!fromId || !toId) {
                return null;
            }

            return {
                fromId,
                toId,
                forwardDate: item.when,
                backwardDate: item.returnDate || null,
                adultsCount: item.passengers.adults,
                childrenCount: item.passengers.children,
                infantsCount: item.passengers.infants,
            };
        })
        .filter(isNotNull);

    return {
        minRequests,
    };
}
