import {isCity} from 'utilities/geo/geoObjectType';

/**
 * Получаем идентификатор населенного пункта из pointKey
 * Для города: 'c54' -> 54
 * Для станции: 's213' -> null
 */
export default function getPointIdByPointKey(pointKey: string): number | null {
    if (!isCity(pointKey)) {
        return null;
    }

    const id = pointKey.match(/\d+/)?.[0];

    if (id === undefined) {
        return null;
    }

    return Number(id);
}
