import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18n from 'i18n/buses-HowToBuyBusesTicket';

import Advantages, {TAdvantage} from 'components/Advantages/Advantages';
import Text from 'components/Text/Text';
import TrainsDirectionsL from 'icons/illustrations/TrainsDirections/TrainsDirectionsL';
import TrainsDiscountL from 'icons/illustrations/TrainDiscount/TrainDiscountL';
import TrainsLoginL from 'icons/illustrations/TrainLogin/TrainLoginL';
import TrainsPayL from 'icons/illustrations/TrainPay/TrainPayL';

interface IHowToBuyBusesTicketProps extends IWithClassName, IWithQaAttributes {}

const HowToBuyBusesTicket: React.FC<IHowToBuyBusesTicketProps> = props => {
    const {className} = props;

    const deviceType = useDeviceType();

    const advantages = useMemo((): TAdvantage[] => {
        const iconWidth = 220;
        const iconHeight = 180;

        return [
            {
                title: i18n.findStepTitle(),
                description: i18n.findStepDescription(),
                iconWidth,
                iconHeight,
                IconComponent: TrainsDirectionsL,
            },
            {
                title: i18n.choiceStepTitle(),
                description: i18n.choiceStepDescription(),
                iconWidth,
                iconHeight,
                IconComponent: TrainsDiscountL,
            },
            {
                title: i18n.bookStepTitle(),
                description: i18n.bookStepDescription(),
                iconWidth,
                iconHeight,
                IconComponent: TrainsLoginL,
            },
            {
                title: i18n.payStepTitle(),
                description: i18n.payStepDescription(),
                iconWidth,
                iconHeight,
                IconComponent: TrainsPayL,
            },
        ];
    }, []);

    const title = useMemo(() => {
        return (
            <Text size={deviceType.isDesktop ? 'xxl' : 'xl'}>
                {insertJSXIntoKey(i18n.title)({
                    start: (
                        <Text size="inherit" weight="fat">
                            {i18n.titleStart()}
                        </Text>
                    ),
                    end: (
                        <Text size="inherit" weight="fat">
                            {i18n.titleEnd()}
                        </Text>
                    ),
                })}
            </Text>
        );
    }, [deviceType]);

    return (
        <Advantages
            className={className}
            title={title}
            advantages={advantages}
            {...prepareQaAttributes(props)}
        />
    );
};

export default HowToBuyBusesTicket;
