import React, {useEffect, useMemo} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {POPULAR_DIRECTIONS_MAX_COUNT} from '../../constants';

import {requestPopularDirectionsThunkAction} from 'reducers/buses/popularDirections/thunk/requestPopularDirectionsThunkAction';

import popularDirectionsSelector from 'selectors/buses/popularDirections/popularDirectionsSelector';

import getSearchUrl from 'projects/buses/utilities/urls/getSearchUrl';

import * as i18nBlock from 'i18n/buses-indexPage';

import FeaturedDirections from 'components/FeaturedDirections/FeaturedDirections';

interface IPopularDirections {
    fromId?: string;
}

/** TODO: переместить в src/components т.к. используется на разных страницах */
const PopularDirections: React.FC<IPopularDirections> = props => {
    const {fromId} = props;
    const {popularDirections, point, isFetched} = useSelector(
        popularDirectionsSelector,
    );

    const dispatch = useDispatch();

    useEffect(() => {
        if (!isFetched) {
            dispatch(
                requestPopularDirectionsThunkAction({
                    fromId,
                    limit: POPULAR_DIRECTIONS_MAX_COUNT,
                }),
            );
        }
    }, [dispatch, isFetched, fromId]);

    const items = useMemo(() => {
        if (!popularDirections) {
            return [];
        }

        return popularDirections.map(({from, to, price}) => ({
            url: getSearchUrl({
                fromSlug: from.slug,
                toSlug: to.slug,
            }),
            text: i18nBlock.popularDashName({
                from: from.title,
                to: to.title,
            }),
            price: price
                ? {currency: price.currency, value: price.amount}
                : null,
        }));
    }, [popularDirections]);

    if (!isFetched || !point || !items.length) {
        return null;
    }

    const title =
        ('titleGenitive' in point ? point.titleGenitive : point.title) || '';

    return (
        <FeaturedDirections
            title={i18nBlock.popularDashTitle({title})}
            items={items}
        />
    );
};

export default React.memo(PopularDirections);
