import {EProjectName} from 'constants/common';

import {ServerDataFetcherBag} from 'server/redux/types';

import prefetchCrossLinks from 'server/redux/common/fetchCrossLinks';
import prefillSearchForm from 'server/redux/buses/prefillSearchForm';

export default async function prefetchData(
    serverFetcherData: ServerDataFetcherBag,
): Promise<void> {
    await Promise.all([
        prefillSearchForm(serverFetcherData),
        prefetchCrossLinks(serverFetcherData, EProjectName.BUSES),
    ]);
}
