import React, {MutableRefObject} from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import previousSearchesSelector from 'selectors/hotels/previousSearches/previousSearchesSelector';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import getPreviousSearchKey from 'projects/hotels/utilities/previousSearches/getPreviousSearchKey';

import Flex from 'components/Flex/Flex';
import {IFormFieldsRef} from 'components/SearchForm/SearchForm';
import PreviousSearch from './components/PreviousSearch/PreviousSearch';

interface IPreviousSearchesProps extends IWithClassName, IWithQaAttributes {
    searchFormFieldsRef: MutableRefObject<IFormFieldsRef | undefined>;
}

const PreviousSearches: React.FC<IPreviousSearchesProps> = props => {
    const {className, searchFormFieldsRef} = props;

    const previousSearches = useSelector(previousSearchesSelector);

    if (!previousSearches.items?.length) {
        return null;
    }

    return (
        <Flex
            className={className}
            between={2}
            inline
            nowrap
            {...prepareQaAttributes(props)}
        >
            {previousSearches.items.map((item, index) => (
                <PreviousSearch
                    key={getPreviousSearchKey(item)}
                    index={index}
                    item={item}
                    searchFormFieldsRef={searchFormFieldsRef}
                />
            ))}
        </Flex>
    );
};

export default React.memo(PreviousSearches);
