import {Location} from 'history';

import getQueryByLocation from 'utilities/getQueryByLocation/getQueryByLocation';

export function getAutoFocusFieldName(location: Location): string | undefined {
    const query = getQueryByLocation(location);
    const focus = query.focus;

    if (focus === undefined || focus === null) {
        return undefined;
    }

    if (Array.isArray(focus)) {
        return focus[0];
    }

    return focus;
}
