import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {ESubscriptionSource} from 'types/subscription/ESubscriptionSource';
import {ESubscriptionVerticalName} from 'types/subscription/ESubscriptionVerticalName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {useIsUserSubscribed} from 'utilities/hooks/subscription/useIsUserSubscribed';
import {useExperiments} from 'utilities/hooks/useExperiments';

import InlineSubscription from 'containers/Subscriptions/Inline/InlineSubscription';

interface IIndexSubscriptionFormProps extends IWithClassName {
    vertical: ESubscriptionVerticalName;
}

const IndexSubscriptionForm: FunctionComponent<IIndexSubscriptionFormProps> =
    props => {
        const {isDesktop} = useDeviceType();
        const isUserSubscribed = useIsUserSubscribed();
        const {rebrandingSubscriptions} = useExperiments();

        if (isUserSubscribed) {
            return null;
        }

        return (
            <InlineSubscription
                {...props}
                rebranding={rebrandingSubscriptions}
                type="wide"
                source={ESubscriptionSource.INDEX}
                headerSize={isDesktop ? 'xxl' : 'xl'}
            />
        );
    };

export default IndexSubscriptionForm;
