import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {TStorybookFunctionComponent} from 'storybook/types';

import AviaIcon from 'icons/24/Flight';

import TabLink from './TabLink';

export default {
    title: 'Index/TabLink',
    component: TabLink,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    return (
        <TabLink
            Icon={AviaIcon}
            isActive={false}
            tabLink="#"
            title="Авиа"
            onClick={(): void => {}}
        />
    );
};

export const SimpleActive: TStorybookFunctionComponent = () => {
    return (
        <TabLink
            Icon={AviaIcon}
            isActive={true}
            tabLink="#"
            title="Авиа"
            onClick={(): void => {}}
        />
    );
};
