import {ComponentType} from 'react';
import {ParsedQuery} from 'query-string';

import {EProjectName} from 'constants/common';
import {URLs} from 'constants/urls';

import {IIconProps} from 'icons/types/icon';
import {ECommonGoal} from 'utilities/metrika/types/goals/common';
import {TMetrikaGoal} from 'utilities/metrika/types/goals/all';

import * as i18nBlock from 'i18n/index';

import IndexAviaLoadable from '../components/IndexAviaLoadable';
import IndexTrainsLoadable from '../components/IndexTrainsLoadable';
import IndexHotelsLoadable from '../components/IndexHotelsLoadable';
import IndexBusesLoadable from '../components/IndexBusesLoadable';
import IndexToursLoadable from '../components/IndexToursLoadable';
import AviaIcon from 'icons/24/Flight';
import TrainsIcon from 'icons/24/Train';
import HotelsIcon from 'icons/24/Hotel';
import BusesIcon from 'icons/24/Bus';
import ToursIcon from 'icons/24/Tours';

export interface ITabContentProps {
    query: ParsedQuery;
}

interface ITabManifest {
    tabTitle: string;
    tabContent: ComponentType<ITabContentProps>;
    tabLink: string;
    metrikaId: TMetrikaGoal;

    icon?: ComponentType<IIconProps>;
}

export default function getTabsManifest(): Record<string, ITabManifest> {
    return {
        [EProjectName.AVIA]: {
            tabTitle: i18nBlock.tabLinkTitleAvia(),
            tabContent: IndexAviaLoadable,
            tabLink: URLs.avia,
            metrikaId: ECommonGoal.AVIA_TAB,
            icon: AviaIcon,
        },
        [EProjectName.TRAINS]: {
            tabTitle: i18nBlock.tabLinkTitleTrains(),
            tabContent: IndexTrainsLoadable,
            tabLink: URLs.trains,
            metrikaId: ECommonGoal.TRAINS_TAB,
            icon: TrainsIcon,
        },
        [EProjectName.HOTELS]: {
            tabTitle: i18nBlock.tabLinkTitleHotels(),
            tabContent: IndexHotelsLoadable,
            tabLink: URLs.hotels,
            metrikaId: ECommonGoal.HOTELS_TAB,
            icon: HotelsIcon,
        },
        [EProjectName.BUSES]: {
            tabTitle: i18nBlock.tabLinkTitleBuses(),
            tabContent: IndexBusesLoadable,
            tabLink: URLs.buses,
            metrikaId: ECommonGoal.BUS_TAB,
            icon: BusesIcon,
        },
        [EProjectName.TOURS]: {
            tabTitle: i18nBlock.tabLinkTitleTours(),
            tabContent: IndexToursLoadable,
            tabLink: URLs.tours,
            metrikaId: ECommonGoal.TOURS_TAB,
            icon: ToursIcon,
        },
    };
}
