import {IWithClassName} from 'types/withClassName';

import * as i18nBlock from 'i18n/tours-LevelTravelBanner';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import LevelTravelLogoM from 'icons/illustrations/LevelTravelLogo/LevelTravelLogoM';

import cx from './LevelTravelBanner.scss';

interface ILevelTravelBannerProps extends IWithClassName {}

const LevelTravelBanner: React.FC<ILevelTravelBannerProps> = ({className}) => {
    return (
        <Flex
            flexWrap="wrap"
            justifyContent="center"
            alignItems="center"
            className={className}
        >
            <LevelTravelLogoM width="113" height="27" />
            <Text className={cx('text')} size="s">
                {i18nBlock.text()}
            </Text>
        </Flex>
    );
};

export default LevelTravelBanner;
