import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/tours-PlusInformation';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';

import cx from './PlusInformation.scss';

interface IPlusInformationProps extends IWithClassName, IWithDeviceType {}

const PlusInformation: React.FC<IPlusInformationProps> = ({className}) => {
    return (
        <Flex
            flexWrap="wrap"
            justifyContent="center"
            alignItems="center"
            className={cx('root', className)}
        >
            <Text className={cx('header')} tag="h1" size="xl" weight="normal">
                {insertJSXIntoKey(i18nBlock.plusInformationNew)({
                    start: (
                        <Text weight="fat" size="inherit">
                            {i18nBlock.plusInformationStart()}
                        </Text>
                    ),
                    end: (
                        <Text weight="fat" size="inherit" whiteSpace="nowrap">
                            {i18nBlock.plusInformationEnd()}
                        </Text>
                    ),
                })}
            </Text>
        </Flex>
    );
};

export default PlusInformation;
