import {IWithClassName} from 'types/withClassName';

import Toggle from 'components/Toggle/Toggle';
import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';

import cx from './DateAccuracyToggle.scss';

export interface IDateAccuracyToggleProps extends IWithClassName {
    toggleClassName?: string;
    text: string;
    isActive: boolean;
    onToggle: () => void;
    justifyContent?: React.CSSProperties['justifyContent'];
}

const DateAccuracyToggle: React.FC<IDateAccuracyToggleProps> = ({
    className,
    toggleClassName,
    text,
    isActive,
    onToggle,
    justifyContent = 'space-between',
}) => {
    return (
        <Flex
            className={cx('root', className)}
            justifyContent={justifyContent}
            alignItems="center"
            onClick={onToggle}
        >
            <Text>{text}</Text>
            <Toggle className={toggleClassName} isActive={isActive} />
        </Flex>
    );
};

export default DateAccuracyToggle;
