import {ESearchFormFieldName} from 'components/SearchForm/types';

import {
    IBaseSuggestItem,
    ISuggestValue,
} from 'components/SearchSuggest/SearchSuggest';

export enum ESuggestDestinationType {
    HOTEL = 'hotel',
    COUNTRY = 'country',
    CITY = 'city',
}

export interface IToursSuggestBase extends IBaseSuggestItem {
    name_en: string;
    iso2: string;
    name_ru: string;
    hotel_ids?: string;
}

export interface IToursSuggestDestination extends IToursSuggestBase {
    // возможно не все типы собрал в enum поэтому | string
    type: ESuggestDestinationType | string;
    visaType?: string;
    country_ru?: string;
}
export interface IToursSuggestDeparture extends IToursSuggestBase {
    iata: string;
}

export interface IToursSearchFormFromPointField
    extends ISuggestValue<IToursSuggestDeparture> {}
export interface IToursSearchFormToPointField
    extends ISuggestValue<IToursSuggestDestination> {}

export type TToursSearchFormDateField = string | null;

export interface IToursSearchFormValues {
    [ESearchFormFieldName.FROM]: IToursSearchFormFromPointField;
    [ESearchFormFieldName.TO]: IToursSearchFormToPointField;
    [ESearchFormFieldName.START_DATE]: TToursSearchFormDateField;
    flexibleDates: boolean;
    flexibleNights: boolean;
    nightsCount: number;
    adults: number;
    childrenAges: number[];
}

export interface IToursSearchFormErrors {
    [ESearchFormFieldName.TO]?: string[];
    [ESearchFormFieldName.FROM]?: string[];
    [ESearchFormFieldName.START_DATE]?: string[];
}
