import {LT_PUBLIC_HOST} from 'projects/index/IndexApp/components/IndexTours/constants';

import {Request} from '@yandex-data-ui/core/lib/types';

import {appendQueryParams} from 'utilities/url/appendQueryParams';

import {levelTravel} from 'serviceProvider/tours/levelTravelProvider/levelTravelProvider';

export default async function getRedirect({
    req,
    label,
    hotel_ids,
    from_city,
    from_country,
    to_country,
    to_city,
    nights,
    start_date,
    adults,
    kids,
    kids_ages,
    flex_dates,
    flex_nights,
}: {
    req?: Request;
    label: string | null;
    hotel_ids?: string;
    from_city: string;
    from_country: string;
    to_country: string;
    to_city?: string;
    nights: number;
    start_date: string | null;
    adults: number;
    kids?: number;
    kids_ages?: (string | number)[];
    flex_dates: boolean;
    flex_nights: boolean;
}): Promise<void> {
    if (!start_date) return;

    const windowReference = window.open();

    const res = await levelTravel.provider(req?.container).getRedirect({
        host: LT_PUBLIC_HOST,
        hotel_ids: hotel_ids,
        from_city,
        from_country,
        to_country,
        to_city,
        nights,
        start_date,
        adults,
        kids,
        kids_ages,
        flex_dates,
        flex_nights,
        redirect: false,
    });

    if (res.redirect_url) {
        const url = appendQueryParams(res.redirect_url, {label});

        if (windowReference) windowReference.location = url;
        else window.location.href = url;
    }
}
