import {ESuggestDestinationType, IToursSearchFormValues} from '../types';

export function getSearchStateQuery({
    childrenAges,
    nightsCount,
    startDate,
    adults,
    from: {selectedValue: from},
    to: {selectedValue: to},
    flexibleNights,
    flexibleDates,
}: IToursSearchFormValues): Record<string, string | number> | null {
    if (!from || !to || !startDate) return null;

    const destinationHotelId = to.hotel_ids ?? to.name_en;
    const destination =
        to.type === ESuggestDestinationType.HOTEL
            ? destinationHotelId
            : to.name_en;

    return {
        departure_from: from.name_en,
        departure_date: startDate,
        nights_count: nightsCount,
        destination,
        adults,
        childrenAges: childrenAges.join(','),
        flexNights: Number(flexibleNights),
        flexDates: Number(flexibleDates),
    };
}
