import {IToursSuggestDeparture, IToursSuggestDestination} from '../types';

import isDeparture from '../utilities/isDepartureSuggest';

export default function getSuggestTitleAndDescription(
    item: IToursSuggestDestination | IToursSuggestDeparture,
): {
    title: string;
    description: string;
} {
    if (!isDeparture(item)) {
        return {
            title: item.name_ru,
            description: item?.visaType || item?.country_ru || '',
        };
    }

    return {
        title: item.name_ru,
        description: '',
    };
}
