import {
    IToursSearchFormErrors,
    IToursSearchFormValues,
    TToursSearchFormDateField,
} from '../types';

import * as i18nBlock from 'i18n/components';

const isEmptyDate = (date: TToursSearchFormDateField): boolean => !date;

export function validateDates(
    fieldsValues: IToursSearchFormValues,
): IToursSearchFormErrors {
    const {startDate} = fieldsValues;
    const errors: IToursSearchFormErrors = {};

    if (isEmptyDate(startDate)) {
        errors.startDate = [
            i18nBlock.aviaSearchFormDotValidateDotStartDateRequired(),
        ];
    }

    return errors;
}
