import {
    IToursSearchFormErrors,
    IToursSearchFormFromPointField,
    IToursSearchFormToPointField,
    IToursSearchFormValues,
} from '../types';

import * as i18nBlock from 'i18n/components';

const isEmptyDirectionValue = ({
    inputValue,
}: IToursSearchFormToPointField | IToursSearchFormFromPointField): boolean =>
    inputValue === '';

const isEmptySelectedValue = ({
    selectedValue,
}: IToursSearchFormToPointField | IToursSearchFormFromPointField): boolean =>
    selectedValue === false;

export function validatePoint(
    fieldsValues: IToursSearchFormValues,
): IToursSearchFormErrors {
    const {to, from} = fieldsValues;
    const errors: IToursSearchFormErrors = {};

    if (from !== undefined && isEmptySelectedValue(from)) {
        errors.from = [
            i18nBlock.aviaSearchFormDotValidateDotFromFieldRequired(),
        ];
    }

    if (from !== undefined && isEmptyDirectionValue(from)) {
        errors.from = [
            i18nBlock.aviaSearchFormDotValidateDotFromFieldRequired(),
        ];
    }

    if (to !== undefined && isEmptySelectedValue(to)) {
        errors.to = [
            i18nBlock.hotelsSearchFormDotValidateDotNeedSelectToField(),
        ];
    }

    if (to !== undefined && isEmptyDirectionValue(to)) {
        errors.to = [i18nBlock.hotelsSearchFormDotValidateDotToFieldRequired()];
    }

    return errors;
}
