import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18n from 'i18n/trains-HowToBuyTrainsTicket';

import Advantages, {TAdvantage} from 'components/Advantages/Advantages';
import Text from 'components/Text/Text';
import TrainsDirectionsL from 'icons/illustrations/TrainsDirections/TrainsDirectionsL';
import TrainsChoiceL from 'icons/illustrations/Trainchoise/TrainchoiseL';
import TrainsLoginL from 'icons/illustrations/TrainLogin/TrainLoginL';
import TrainsPayL from 'icons/illustrations/TrainPay/TrainPayL';

interface IHowToBuyTrainsTicketProps
    extends IWithClassName,
        IWithQaAttributes {}

const HowToBuyTrainsTicket: React.FC<IHowToBuyTrainsTicketProps> = props => {
    const {className} = props;

    const deviceType = useDeviceType();

    const advantages = useMemo((): TAdvantage[] => {
        const iconWidth = 220;
        const iconHeight = 180;

        return [
            {
                title: i18n.choiceRouteStepTitle(),
                description: i18n.choiceRouteStepDescription(),
                iconWidth,
                iconHeight,
                IconComponent: TrainsDirectionsL,
            },
            {
                title: i18n.choicePlacesStepTitle(),
                description: i18n.choicePlacesStepDescription(),
                iconWidth,
                iconHeight,
                IconComponent: TrainsChoiceL,
            },
            {
                title: i18n.fillPassengersStepTitle(),
                description: i18n.fillPassengersStepDescription(),
                iconWidth,
                iconHeight,
                IconComponent: TrainsLoginL,
            },
            {
                title: i18n.payStepTitle(),
                description: i18n.payStepDescription(),
                iconWidth,
                iconHeight,
                IconComponent: TrainsPayL,
            },
        ];
    }, []);

    const title = useMemo(() => {
        return (
            <Text size={deviceType.isDesktop ? 'xxl' : 'xl'}>
                {insertJSXIntoKey(i18n.title)({
                    start: (
                        <Text size="inherit" weight="fat">
                            {i18n.titleStart()}
                        </Text>
                    ),
                    end: (
                        <Text size="inherit" weight="fat">
                            {i18n.titleEnd()}
                        </Text>
                    ),
                })}
            </Text>
        );
    }, [deviceType]);

    return (
        <Advantages
            className={className}
            title={title}
            advantages={advantages}
            {...prepareQaAttributes(props)}
        />
    );
};

export default HowToBuyTrainsTicket;
